/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.biomes;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.api.v2.levelgen.surface.rules.SwitchRuleSource;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.features.placed.NetherObjectsPlaced;
import org.betterx.betternether.registry.features.placed.NetherTerrainPlaced;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeConfig;

public class NetherSoulPlain
extends NetherBiome {
    private static final SurfaceRules.RuleSource SOUL_SAND = SurfaceRules.m_189390_((BlockState)Blocks.f_50135_.m_49966_());
    private static final SurfaceRules.RuleSource SOUL_SOIL = SurfaceRules.m_189390_((BlockState)Blocks.f_50136_.m_49966_());
    private static final SurfaceRules.RuleSource SOUL_SANDSTONE = SurfaceRules.m_189390_((BlockState)NetherBlocks.SOUL_SANDSTONE.m_49966_());
    private static final SurfaceRules.RuleSource LAVA = SurfaceRules.m_189390_((BlockState)Blocks.f_50450_.m_49966_());

    public NetherSoulPlain(ResourceKey<Biome> biomeID, BCLBiomeSettings settings) {
        super(biomeID, settings);
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(196, 113, 239).loop((Holder)SoundEvents.f_11954_).additions((Holder)SoundEvents.f_11901_).mood((Holder)SoundEvents.f_12007_).music((Holder)SoundEvents.f_12156_).particles((ParticleOptions)ParticleTypes.f_123760_, 0.02f).structure(BiomeTags.f_207598_).feature(NetherTerrainPlaced.REPLACE_SOUL_SANDSTONE).feature(NetherFeatures.NETHER_RUBY_ORE_SOUL).feature(NetherObjectsPlaced.BASALT_STALAGMITE_SPARSE).feature(NetherVegetationPlaced.BLACK_BUSH).feature(NetherVegetationPlaced.VEGETATION_SOUL_PLAIN).feature(NetherObjectsPlaced.BASALT_STALACTITE_SPARSE).addNetherClimateParamater(0.01f, -0.5f, 0.0f);
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return NetherSoulPlain::new;
        }

        @Override
        public SurfaceRuleBuilder surface() {
            SurfaceRules.RuleSource soilSandDist = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)Conditions.NETHER_VOLUME_NOISE, (SurfaceRules.RuleSource)SOUL_SOIL), SOUL_SAND});
            SurfaceRules.RuleSource soilSandStoneDist = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{new SwitchRuleSource(Conditions.NETHER_NOISE, List.of(SOUL_SOIL, SOUL_SAND, SOUL_SANDSTONE, LAVA, LAVA, SOUL_SAND))});
            SurfaceRules.RuleSource soilStoneDist = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)Conditions.NETHER_VOLUME_NOISE, (SurfaceRules.RuleSource)SOUL_SOIL), SOUL_SANDSTONE});
            return super.surface().rule(2, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)soilSandDist)).ceil(NetherBlocks.SOUL_SANDSTONE.m_49966_()).rule(4, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189378_, (SurfaceRules.RuleSource)soilStoneDist)).rule(5, soilSandStoneDist);
        }
    }
}

